#!/bin/sh

MASTER_PAGE_SB_RECONFIG_RESULT_MSG=""
MASTER_PAGE_SB_RECONFIG_RESULT_OK=0
MASTER_PAGE_SB_RECONFIG_RESULT_ERROR=1

MASTER_PAGE_SB_RECONFIG_RESULT_CODE=${MASTER_PAGE_SB_RECONFIG_RESULT_ERROR}
MASTER_PAGE_SB_RECONFIG_RESULT_ROLLING=0

master_page_sb_reconfig() {
    debug_print "in function '${FUNCNAME[0]}'"
    
    ################################################################################
    # user must disconnect all clusters before reconfiging internet connection for sandboxes
    ################################################################################
    debug_print "CheckIfAnyClusterExists..."
    local msg
    msg=`php ${CONS_BACKEND} get_cluster_number_from_db`
    ret="${?}"
    if [ "${ret}" -ne 0 ]; then
        debug_print "GetClusterTotalNumberFail: ret='${ret}', msg='${msg}'"
        
        MASTER_PAGE_SB_RECONFIG_RESULT_CODE=$MASTER_PAGE_SB_RECONFIG_RESULT_ERROR
        MASTER_PAGE_SB_RECONFIG_RESULT_ROLLING=-1
        MASTER_PAGE_SB_RECONFIG_RESULT_MSG="${msg}"
        return
        
    elif [ "${msg}" -ne 0 ]; then
        debug_print "ClusterExist: ret='${ret}', clusterTotalNumber='${msg}'"
        
		# tp_msg_ok \
			# "${MASTER_PAGE_SB_RECONFIG_REMOVE_CLUSTER_TITLE}" \
			# "${MASTER_PAGE_SB_RECONFIG_REMOVE_CLUSTER_TEXT}" \
			# "${MASTER_PAGE_SB_RECONFIG_REMOVE_CLUSTER_OK_LABEL}"
            
        MASTER_PAGE_SB_RECONFIG_RESULT_CODE=$MASTER_PAGE_SB_RECONFIG_RESULT_ERROR
        MASTER_PAGE_SB_RECONFIG_RESULT_ROLLING=-1
        MASTER_PAGE_SB_RECONFIG_RESULT_MSG="${MASTER_PAGE_SB_RECONFIG_REMOVE_CLUSTER_TEXT}"
        return
    fi
    debug_print "ClusterNotExist: ret='${ret}', clusterTotalNumber='${msg}'"
    
    
    ################################################################################
    # check if any available active sandbox image type
    ################################################################################
    debug_print "CheckIfAnyActiveImageExists..."
    msg=`php ${CONS_BACKEND} get_active_image_number_from_db`
    ret="${?}"
    if [ "${ret}" -ne 0 ]; then
        debug_print "GetActiveImageTotalNumberFail: ret='${ret}', msg='${msg}'"

        MASTER_PAGE_SB_RECONFIG_RESULT_CODE=$MASTER_PAGE_SB_RECONFIG_RESULT_ERROR
        MASTER_PAGE_SB_RECONFIG_RESULT_ROLLING=-1
        MASTER_PAGE_SB_RECONFIG_RESULT_MSG="${msg}"
        return
    fi
    local activeImageNumber="${msg}"
    debug_print "GetActiveImageTotalNumberPass: ret='${ret}', activeImageNumber='${activeImageNumber}'"

    
    ################################################################################
    # check if displays sandbox number configuration page
    ################################################################################
    debug_print "CheckIfDisplaySbNumberConfPage..."
    
    local sb_reconfig_pages_array
    if [ "${activeImageNumber}" -eq 0 ]; then
        debug_print "DisplaySbNumberConfPage: activeImageNumagber='${activeImageNumber}'"
        
		sb_reconfig_pages_array="master_page_sb_num_conf"
    else
        debug_print "NotToDisplaySbNumberConfPage: activeImageNumagber='${activeImageNumber}'"
    fi
    
    
    sb_reconfig_pages_array="\
        ${sb_reconfig_pages_array} \
        master_page_sb_image_path_select \
        master_page_sb_image_path_confirm \
        master_page_sb_reinstall \
        master_page_sb_deploy_done"
        
    pages_roller "${sb_reconfig_pages_array}"

	MASTER_PAGE_SB_RECONFIG_RESULT_CODE=$MASTER_PAGE_SB_RECONFIG_RESULT_OK
	MASTER_PAGE_SB_RECONFIG_RESULT_ROLLING=-1
}